// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_INTERNAL_H
#define HW_INTERNAL_H

#include "hardware.h"
#include "buffer.h"
#include "common.h"
#include "memcard.h"
#include <dxerr9.h>

#define SETHWFLAGS(offset, flags) hww(offset, hrw(offset) | (flags))
#define CLEARHWFLAGS(offset, flags) hww(offset, hrw(offset) & ~(flags))
//External versions
#define ESETHWFLAGS(offset, flags) h->hww(offset, h->hrw(offset) | (flags))
#define ECLEARHWFLAGS(offset, flags) h->hww(offset, h->hrw(offset) & ~(flags))

//Conditional Set
#define CSETHWFLAGS(offset, flags, condition) {\
	if(condition) SETHWFLAGS(offset, flags);\
	else CLEARHWFLAGS(offset, flags); }
//External version
#define ECSETHWFLAGS(offset, flags, condition) {\
	if(condition) ESETHWFLAGS(offset, flags);\
	else ECLEARHWFLAGS(offset, flags); }

#define CLEARINTFLAGS(old, data, flags) \
	(((data) & ~(flags)) | ((old) & (flags) & ~((data) & (flags))))

#define GPDEGUB if(g::gp_log) DEGUB
#define VGPDEGUB if(g::gp_log && g::verbose) DEGUB

#define VISI_TIMEOUT (1*M)
#define VISI_LOG ((g::log_interrupts || g::gp_log) && g::verbose)

#define INTEX_ERROR	0x0001
#define INTEX_RSW	0x0002
#define INTEX_DI	0x0004
#define INTEX_SI	0x0008
#define INTEX_EXI	0x0010
#define INTEX_AI	0x0020
#define INTEX_DSP	0x0040
#define INTEX_MEM	0x0080
#define INTEX_VI	0x0100
#define INTEX_PETOKEN	0x0200
#define INTEX_PEFINISH	0x0400
#define INTEX_CP	0x0800
#define INTEX_DEBUG	0x1000
#define INTEX_HSP	0x2000

#define HWTIMINGS(macro) macro(HW) macro(VI) macro(GX) macro(FIFO) macro(DSP)
#define HWT_(id) HWT_##id,
enum HWTiming { HWTIMINGS(HWT_) N_HWTIMINGS };

#endif	//HW_INTERNAL_H
